
var touchDevice = window.matchMedia("(pointer: coarse)").matches
function initMap() {
    // The location of Uluru
    var uluru = {lat: 37.738813, lng: 29.092805};
    // The new location
    var newLocation = {lat: 52.24781903391101, lng: 20.987898798132857};

    var british = {lat: 51.5258874, lng: -0.0860133718};

    var center = {lat: (uluru.lat + newLocation.lat + british.lat) / 3, lng: (uluru.lng + newLocation.lng + british.lng) / 3}
    // The map, centered at Uluru
    var map = new google.maps.Map(
        document.getElementById('map'), {
            zoom: touchDevice ? 3.5 : 5,
            center: center,
            disableDefaultUI: true,
            gestureHandling: false,
            zoomControl: false,
            scaleControl: false,
            scrollwheel: false,
            styles: [
                    {
                        "elementType": "labels",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "administrative",
                        "elementType": "geometry",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "administrative.land_parcel",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "administrative.neighborhood",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "landscape",
                        "elementType": "geometry",
                        "stylers": [
                        {
                            "color": "#f3f3f5"
                        },
                        {
                            "visibility": "on"
                        }
                        ]
                    },
                    {
                        "featureType": "poi",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "road",
                        "stylers": [
                        {
                            "color": "#ffffff"
                        },
                        {
                            "visibility": "on"
                        }
                        ]
                    },
                    {
                        "featureType": "road",
                        "elementType": "geometry",
                        "stylers": [
                        {
                            "color": "#ffffff"
                        },
                        {
                            "visibility": "on"
                        }
                        ]
                    },
                    {
                        "featureType": "road",
                        "elementType": "labels.icon",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "road.highway",
                        "stylers": [
                        {
                            "color": "#ffffff"
                        },
                        {
                            "visibility": "on"
                        }
                        ]
                    },
                    {
                        "featureType": "transit",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "water",
                        "stylers": [
                        {
                            "color": "#bac2c9"
                        },
                        {
                            "visibility": "on"
                        }
                        ]
                    }
                    ]
        });


    var pinSVGFilled = "M32,0C18.746,0,8,10.746,8,24c0,5.219,1.711,10.008,4.555,13.93c0.051,0.094,0.059,0.199,0.117,0.289l16,24 C29.414,63.332,30.664,64,32,64s2.586-0.668,3.328-1.781l16-24c0.059-0.09,0.066-0.195,0.117-0.289C54.289,34.008,56,29.219,56,24 C56,10.746,45.254,0,32,0z M32,32c-4.418,0-8-3.582-8-8s3.582-8,8-8s8,3.582,8,8S36.418,32,32,32z";
    var markerImage = {  // https://developers.google.com/maps/documentation/javascript/reference/marker#MarkerLabel
        path: pinSVGFilled,
        anchor: new google.maps.Point(26, 63),
        fillOpacity: 1,
        fillColor: "#ACDB31",
        strokeWeight: 2,
        strokeColor: "#ACDB31",
        scale: .6,
    };

    var marker1 = new google.maps.Marker({
        map: map,
        position: uluru,
        icon: markerImage,
    });

    var marker2 = new google.maps.Marker({
        map: map,
        position: newLocation,
        icon: markerImage,
    });

    var marker3 = new google.maps.Marker({
        map: map,
        position: british,
        icon: markerImage,
    });
    /*
    const marker = new google.maps.marker.AdvancedMarkerElement({
        position: newLocation,
        title: `${1}. ${'title'}`,
        gmpClickable: true,
        map: map
    });
    */

    const zoomInButton = document.createElement("button");
    zoomInButton.setAttribute('class', 'zoom-button')
    zoomInButton.innerHTML = '<div class="plus"><div class="line-vertical"></div><div class="line-horizontal"></div></div>';
    zoomInButton.addEventListener("click", () => {
        map.setZoom(map.getZoom()+1);
    });
    const zoomOutButton = document.createElement("button");
    zoomOutButton.setAttribute('class', 'zoom-button')
    zoomOutButton.innerHTML = '<div class="minus"><div class="line-vertical"></div><div class="line-horizontal"></div></div>';
    zoomOutButton.addEventListener("click", () => {
        map.setZoom(map.getZoom()-1);
    });

    map.controls[google.maps.ControlPosition.BOTTOM_RIGHT].push(zoomInButton);
    map.controls[google.maps.ControlPosition.BOTTOM_RIGHT].push(zoomOutButton);

    /*
    const pin = new google.maps.marker.PinElement({
        //@ts-ignore
        glyphText: `${1}`,
        scale: 1.5,
    });
    const marker = new google.maps.marker.AdvancedMarkerElement({
        position: newLocation,
        title: `${1}. ${'title'}`,
        gmpClickable: true,
        map: map
    });
    marker.append(pin);
    */
}