<?php

namespace App\AppBundle\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;
use App\Controller\DefaultController;
use App\Controller\ProjectController;
use App\Controller\BlogController;
use App\Controller\ReferenceController;
use App\Controller\ContactController;
use App\Controller\StaffController;
use App\Controller\PartnerController;
use App\Controller\ServiceController;
use App\Entity\ProjectTag;
use App\Entity\BlogTag;
use App\Entity\Page;
use Symfony\Component\HttpFoundation\Request;

class AppExtension extends AbstractExtension
{
    private $defaultController;
    private $projectController;
    private $blogController;
    private $referenceController;
    private $contactController;
    private $staffController;
    private $partnerController;
    private $serviceController;

    public function __construct(
            DefaultController $defaultController,
            ProjectController $projectController,
            BlogController $blogController,
            ReferenceController $referenceController,
            ContactController $contactController,
            StaffController $staffController,
            PartnerController $partnerController,
            ServiceController $serviceController
        ){
        $this->defaultController = $defaultController;
        $this->projectController = $projectController;
        $this->blogController = $blogController;
        $this->referenceController = $referenceController;
        $this->contactController = $contactController;
        $this->staffController = $staffController;
        $this->partnerController = $partnerController;
        $this->serviceController = $serviceController;
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('getText', [$this, 'getText']),
            new TwigFunction('getLang', [$this, 'getLang']),
            new TwigFunction('getLocations', [$this, 'getLocations']),
            new TwigFunction('getPages', [$this, 'getPages']),
            new TwigFunction('getPageLang', [$this, 'getPageLang']),
            new TwigFunction('getAppSetting', [$this, 'getAppSetting']),
            new TwigFunction('regexGet', [$this, 'regexGet']),
            new TwigFunction('setKey', [$this, 'setKey']),
            new TwigFunction('getElementContent', [$this, 'getElementContent']),
            new TwigFunction('formatString', [$this, 'formatString']),
            new TwigFunction('getProjects', [$this->projectController, 'getProjects']),
            new TwigFunction('getProjectTag', [$this->projectController, 'getProjectTag']),
            new TwigFunction('getProjectTags', [$this->projectController, 'getProjectTags']),
            new TwigFunction('getBlogs', [$this->blogController, 'getBlogs']),
            new TwigFunction('getBlogTag', [$this->blogController, 'getBlogTag']),
            new TwigFunction('getBlogLang', [$this->blogController, 'getBlogLang']),
            new TwigFunction('getBlogTags', [$this->blogController, 'getBlogTags']),
            new TwigFunction('getReferences', [$this->referenceController, 'getReferences']),
            new TwigFunction('getReferenceCountries', [$this->referenceController, 'getReferenceCountries']),
            new TwigFunction('getQueryTypes', [$this->contactController, 'getQueryTypes']),
            new TwigFunction('getStaff', [$this->staffController, 'getStaff']),
            new TwigFunction('getPartners', [$this->partnerController, 'getPartners']),
            new TwigFunction('getServices', [$this->serviceController, 'getServices']),
            new TwigFunction('getServiceLang', [$this->serviceController, 'getServiceLang'])
        ];
    }

    public function getText($identifier, Request $request){
        return $this->defaultController->getLangText($identifier, $request);
    }

    public function getLang($langs, $request){
        return $this->defaultController->getLang($langs, $request);
    }
    
    public function getLocations(Array $options = []){
        return $this->defaultController->getLocations($options);
    }

    public function getAppSetting(){
        return $this->defaultController->getAppSetting();
    }

    public function getPages(Array $options = [], Request $request){
        return $this->defaultController->getPages($options, $request);
    }
    
    public function getPageLang(Page $page, string $language){
        return $this->defaultController->getPageLang($page, $language);
    }

    function regexGet($string, $pattern, $index=0) {
        preg_match($pattern, $string, $m);
        if(count($m) > 0){
            return $m[$index];
        }else{
            return false;
        }
    }

    function setKey($array, $key, $value){
        $array[($key)] = $value;
    }

    function getElementContent(string $text, string $element): array{
        $text = preg_replace('/\s\s+/', '', $text);
        $beforePattern = "~^.+?(?=<".$element.">)~";
        $contentPattern = "~<".$element.">(.*?)</".$element.">~";
        $afterPattern = "~(?<=</".$element.">).+~";
        return [
            "before" => $this->regexGet($text, $beforePattern, 0),
            "content" => $this->regexGet($text, $contentPattern, 1),
            "after" => $this->regexGet($text, $afterPattern, 0)
        ];
    }

    function formatString($text, $currentLocation = null, $currentLocationLang = null){
        $text = preg_replace('/\s\s+/', '', $text);
        if (strpos($text, '<list>')){
            $content = $this->getElementContent($text, 'list');
            $newText = $content['before'] . "<ul class='list'";
            $endText = $content['after'];
            if ($endText){
                // Add padding if there is text at the bottom
                $newText = $newText . " style='padding-bottom:20px'";
            }
            $newText = $newText . ">";
            foreach (explode("*", $content['content']) as $item){
                if ($item && strlen($item) > 1){
                    $newText = $newText . '<li>' . $item . '</li>';
                }
            }
            $newText = $newText . "</ul>" . $endText;
            return $this->formatString($newText, $currentLocation, $currentLocationLang);
        }
        
        elseif (strpos($text, '<sectionTitle>')){
            $content = $this->getElementContent($text, 'sectionTitle');
            $newText = $content['before'] . "<div class='content-title-wrapper'><div class='content-title'>" . $content['content'] . "</div></div>" . $content['after'];
            return $this->formatString($newText, $currentLocation, $currentLocationLang);
        }

        elseif (strpos($text, '<link>')){
            $content = $this->getElementContent($text, 'link');
            $link = explode(":", $content['content']);
            $newText = $content['before'] . "<a href='https://" . $link[1] . "'>" . $link[0] . "</a>" . $content['after'];
            return $this->formatString($newText, $currentLocation, $currentLocationLang);
        }
        
        else{
            return $text;
        }

    }

}
