<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Doctrine\ORM\EntityManagerInterface;
use App\Entity\ContactQueryType;
use App\Controller\DefaultController;

class ContactController extends AbstractController{

    private $em;
    private $defaultController;

    public function __construct(EntityManagerInterface $em, DefaultController $defaultController){
        $this->em = $em;
        $this->defaultController = $defaultController;
    }    

    public function getQueryTypes(){
        return $this->em->getRepository(ContactQueryType::class)->findAll();
    }
    
    #[Route(path: [
        'tr' => '/iletisim',
        'en' => '/{_locale}/contact',
        'de' => '/{_locale}/kontakt'
    ], name: 'contact')]
    public function contactpage(){
        return $this->defaultController->renderPage('contact.html.twig');
    }
    
}