<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Component\Mime\Email;
use Symfony\Component\Mime\Address;
use Symfony\Component\Routing\Attribute\Route;

class MailerController extends AbstractController
{
    #[Route('/send_email')]
    public function sendContactMail(MailerInterface $mailer, Request $request){
        $firstName = $request->query->get('firstName');
        $lastName = $request->query->get('lastName');
        $mail = $request->query->get('mail');
        $queryType = $request->query->get('queryType');
        $message = $request->query->get('message');

        $mailer->send((new TemplatedEmail())
            ->from(new Address($this->getParameter('app.mailAddress')))
            ->to(new Address($this->getParameter('app.recieverMailAddress')))
            ->subject('Yeni İletişim Talebi!')
            ->htmlTemplate('mail-template.html.twig')
            ->context([
                'firstName' => $firstName,
                'lastName' => $lastName,
                'mail' => $mail,
                'queryType' => $queryType,
                'message' => $message
            ])
        );
        return new Response();
    }
}