<?php

namespace App\Controller;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Doctrine\ORM\EntityManagerInterface;
use App\Controller\DefaultController;
use App\Entity\Partner;

class PartnerController extends AbstractController{

    private $em;
    private $defaultController;

    public function __construct(EntityManagerInterface $em, DefaultController $defaultController){
        $this->em = $em;
        $this->defaultController = $defaultController;
    }

    public function getPartners(){
        return $this->em->getRepository(Partner::class)->findAll();
    }

    #[Route([
        'tr' => '/ortakliklar',
        'en' => '/{_locale}/partners',
        'de' => '/{_locale}/partnerschaften'
    ], name: 'partners')]
    public function partnerspage()
    {
        return $this->defaultController->renderPage('partners.html.twig', [
            'breadcrumb' => ["corporate"]
        ]);
    }

}