<?php

namespace App\Controller;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestEvent;
use Doctrine\ORM\EntityManagerInterface;
use App\Entity;
use App\Entity\Project;
use App\Entity\ProjectTag;
use App\Entity\ProjectLang;
use App\Controller\DefaultController;

class ProjectController extends AbstractController{

    private $em;
    private $defaultController;

    public function __construct(EntityManagerInterface $em, DefaultController $defaultController){
        $this->em = $em;
        $this->defaultController = $defaultController;
    }

    public function getProjectTag($id, Request $request){
        return $this->defaultController->getTagTextFromId($id, ProjectTag::class, $request);
    }

    public function getProjectTags(Request $request):array{
        $projectTagArray = [];
        $projectTags = $this->em->getRepository(ProjectTag::class)->findAll();
        foreach($projectTags as $projectTag){
            $projectTagArray[$projectTag->getIdentifier()] = $this->defaultController->getLangText($projectTag->getIdentifier(), $request);
        };
        return $projectTagArray;
    }

    public function getProjects(array $args=[], Request $request): array{
        $projects = $this->em->getRepository(Project::class)->createQueryBuilder('project')
        ->select('project')
        ->leftJoin('project.projectLangs', 'lang')
        ->addSelect('lang')
        ->andWhere('lang.lang = ' . $this->defaultController->localeIndex[$request->getLocale()]);


        if (array_key_exists('homeBrands', $args) && $args['homeBrands']){
            $projects->andwhere('project.is_at_home_brands = 1');
        }

        if (array_key_exists('homeProjects', $args) && $args['homeProjects']){
            $projects->andwhere('project.is_at_home_projects = 1');
        }

        if (array_key_exists('projectsPage', $args) && $args['projectsPage']){
            $projects->andwhere('project.is_at_projects_page = 1');
        }

        if (array_key_exists('query', $args) && $args['query']){
            $keywords = explode(' ', $args['query']);
            foreach($keywords as $keyword){
                $projects->andwhere("lang.title LIKE '%".$keyword."%'");
            }
        }

        if (array_key_exists('tags', $args) && $args['tags']){
            foreach(explode(',', $args['tags']) as $tag){
                $projects->andwhere('JSON_CONTAINS(project.tag_identifier_array, \'"' . $tag . '"\') = true');
            }
        }

        return $projects->getQuery()->getResult();
    }

    #[Route(path: [
    'tr' => '/projelerimiz',
    'en' => '{_locale}/our-projects',
    'de' => '{_locale}/unsere-projekte'
    ], name: 'projects')]
    public function projectspage(Request $request, string $_locale)
    {
        return $this->defaultController->renderPage('projects.html.twig');
    }

    #[Route(path: '/{_locale}/project-search', name: 'project_search')]
    public function projectsearch(Request $request)
    {
        return $this->defaultController->renderPage('components/_projects-content.html.twig');
    }
}
