<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\ORM\EntityManagerInterface;
use App\Controller\DefaultController;
use App\Entity\ProjectPage;
use App\Entity\Project;

class ProjectPageController extends AbstractController{

    private $em;
    private $defaultController;

    public function __construct(EntityManagerInterface $em, DefaultController $defaultController){
        $this->em = $em;
        $this->defaultController = $defaultController;
    }

    #[Route([
        'tr' => '/marka/{project_name}',
        'en' => '/{_locale}/brand/{project_name}',
        'de' => '/{_locale}/marke/{project_name}'
    ], name: "project_page")]
    public function projectpages(Request $request, EntityManagerInterface $em, string $project_name, )
    {
        $page = $em->getRepository(ProjectPage::class)->findOneBy(['name' => $project_name, 'is_enabled' => true]);
        if (!$page) {
            throw $this->createNotFoundException(
                'Page not found'
            );
        }
        $pageContent = $page->getContent();
        $pageLang = $this->defaultController->getLang($page->getProjectPageLangs(), $request);
        $title = $pageLang->getTitle();
        $description = $pageLang->getDescription();
        return $this->defaultController->renderPage('project/index.html.twig', [
            'breadcrumb' => ['expertise'],
            'projectName' => $project_name,
            'content' => $pageContent,
            'title' => $title,
            'link' => $em->getRepository(Project::class)->findOneBy(['identifier' => $project_name])->getLink(),
            'description' => $description
        ]);
    }


}