<?php

namespace App\Controller;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestEvent;
use Doctrine\ORM\EntityManagerInterface;
use App\Entity;
use App\Entity\Reference;
use App\Entity\ReferenceLang;
use App\Controller\DefaultController;

class ReferenceController extends AbstractController{

    private $em;
    private $defaultController;

    public function __construct(EntityManagerInterface $em, DefaultController $defaultController){
        $this->em = $em;
        $this->defaultController = $defaultController;
    }

    public function getReferenceCountries():array{
        return $this->em->getRepository(Reference::class)->createQueryBuilder('reference')
        ->select('reference.country_code')
        ->getQuery()->getResult();
    }

    public function getReferences(array $args=[], Request $request): array{
        $references = $this->em->getRepository(Reference::class)->createQueryBuilder('reference')
            ->select('reference')
            ->where('reference.is_enabled = 1')
            ->leftJoin('reference.referenceLangs', 'lang')
            ->addSelect('lang')
            ->andWhere('lang.lang = ' . $this->defaultController->localeIndex[$request->getLocale()])
            ->addOrderBy('reference.sort_order', 'ASC');
        if (array_key_exists('query', $args) && $args['query']){
            $keywords = explode(' ', $args['query']);
            foreach($keywords as $keyword){
                $references->andwhere("lang.title LIKE '%".$keyword."%'");
            }
        }

        if (array_key_exists('tags', $args) && $args['tags']){
            $references
            ->andWhere('reference.country_code = :country_code')
            ->setParameter('country_code', $args['tags']);
        }

        return $references->getQuery()->getResult();
    }


    #[Route(path: [
        '/{_locale}/reference_popup/{id}'
    ])]
    public function referencePopup(Request $request, int $id){
        $reference = $this->em->getRepository(Reference::class)->findOneBy(['id'=>$id, 'has_popup'=> true]);
        if($reference){
            $referenceLang = $this->defaultController->getLang($reference->getReferenceLangs(), $request);
            $referenceLang->logoImage = $reference->getLogoImage();
            return $this->defaultController->renderPage('components/_popup.html.twig', ['referencePopup' => $referenceLang]);
        }
    }
    
    #[Route(path: [
        'tr' => '/referanslar',
        'en' => '/{_locale}/references',
        'de' => '/{_locale}/referenzen'
    ], name: 'references')]
    public function referencespage(Request $request): Response{
        $s=$request->query->get('s');
        $tags=$request->query->get('tags');
        return $this->defaultController->renderPage('references.html.twig');
    }

    #[Route(path: '/{_locale}/reference-search', name: 'reference_search')]
    public function referencesearch(Request $request): Response{
        $s=$request->query->get('s');
        $tags=$request->query->get('tags');
        return $this->defaultController->renderPage('components/_references-content.html.twig');
    }
}
