<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\ORM\EntityManagerInterface;
use App\Controller\DefaultController;
use App\Controller\ReferenceController;
use App\Entity\Service;
use App\Entity\ServiceContent;
use App\Entity\ServiceLang;
use App\Entity\Reference;
use App\Controller\SitemapController;

class ServiceController extends AbstractController{

    private $em;
    private $defaultController;
    private $referenceController;

    public function __construct(EntityManagerInterface $em, DefaultController $defaultController, ReferenceController $referenceController){
        $this->em = $em;
        $this->defaultController = $defaultController;
        $this->referenceController = $referenceController;
    }

    public function getServiceLang(Service $service, string $locale){
        return $this->em->getRepository(ServiceLang::class)->findOneBy(['service'=>$service->getId(), 'lang' => $this->defaultController->localeIndex[$locale]]);
    }

    public function getServices(Request $request){
        return $this->em->getRepository(Service::class)->createQueryBuilder('service')
        ->select('service')
        ->leftJoin('service.serviceLangs', 'lang')
        ->andWhere('lang.lang = '.$this->defaultController->localeIndex[$request->getLocale()])
        ->getQuery()->getResult();
    }

    #[Route(path: [
        'tr' => '/hizmetlerimiz',
        'en' => '/{_locale}/our-services',
        'de' => '/{_locale}/unsere-leistungen'
    ], name: 'services')]
    public function servicespage(){
        return $this->defaultController->renderPage('services.html.twig', ['breadcrumb' => ["expertise"]]);
    }

    #[Route(path: [
        'tr' => '/{alias}',
        'en' => '/{_locale}/{alias}',
        'de' => '/{_locale}/{alias}'
    ], name: 'service_detail')]
    public function servicedetailpage(Request $request, string $_locale, string $alias, SitemapController  $sitemapController){
        $serviceLang = $this->em->getRepository(ServiceLang::class)->findOneBy(['alias'=> $alias]);
        if (!$serviceLang){
            $service = $this->em->getRepository(Service::class)->findOneBy(['alias'=> $alias]);
            if(!$service){
                return throw $this->createNotFoundException();
                /*$sitemapPagePathArray = [
                    'tr' => 'site-haritasi',
                    'en' => 'sitemap',
                    'de' => 'sitemap'
                ];
                if ($alias == 'sitemap.xml'){return $sitemapController->sitemapxml($request);}
                if ($alias == $sitemapPagePathArray[$_locale]){return $sitemapController->sitemappage($request);}
                */
            }
            $serviceLang = $this->defaultController->getLang($service->getServiceLangs(), $request);
            return $this->redirectToRoute('service_detail', ['alias' => $serviceLang->getAlias()]);
        }
        else{
            $service = $serviceLang->getService();
            if ($serviceLang->getLang()->getId() != $this->defaultController->localeIndex[$request->getLocale()]){
                $serviceLangDirect = $this->defaultController->getLang($service->getServiceLangs(), $request);
                if ($serviceLangDirect){
                    return $this->redirectToRoute('service_detail', ['alias'=>$serviceLangDirect->getAlias()]);
                }
            }
        }
        $references = $this->em->getRepository(Reference::class)->createQueryBuilder('reference')
        ->select('reference');
        $referenceArray = $service->getReferenceIdentiferArray();
        if ($referenceArray){
            if ($referenceArray &&  count($referenceArray) > 0){
                $references = $references->where("reference.identifier IN ('".implode("','", $service->getReferenceIdentiferArray())."')")->getQuery()->getResult();
            }else{
                $references = [];
            }
        }else{
            $references = [];
        }
        if ($serviceLang){
            return $this->defaultController->renderPage('service-detail.html.twig', [
                'breadcrumb'=> ['expertise', 'services'],
                'service' => $service,
                'serviceLang' => $serviceLang,
                'references' => $references
            ]);
        }
        return throw $this->createNotFoundException();
    }
}