<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use App\Entity\Project;
use App\Entity\ProjectPage;
use App\Entity\Service;
use App\Entity\Blog;
use App\Entity\Page;

class SitemapController extends AbstractController
{
    private $defaultController;

    public function __construct(DefaultController $defaultController){
        $this->defaultController = $defaultController;
    }

    public function getSitemap(Request $request){
        $urls = [];
        $urls[] = [
            'loc' => $this->generateUrl('homepage'),
            'priority' => '1.00',
            'title' => 'homepage'
        ];
        $urls[] = [
            'loc' => $this->generateUrl('about_us', []),
            'priority' => '0.80',
            'title' => 'about_us'
        ];
        $urls[] = [
            'loc' => $this->generateUrl('offices', []),
            'priority' => '0.80',
            'title' => 'offices'
        ];
        $urls[] = [
            'loc' => $this->generateUrl('staff', []),
            'priority' => '0.80',
            'title' => 'staff'
        ];
        $urls[] = [
            'loc' => $this->generateUrl('partners', []),
            'priority' => '0.80',
            'title' => 'partners'
        ];
        $urls[] = [
            'loc' => $this->generateUrl('services', []),
            'priority' => '0.64',
            'title' => 'services'
        ];
        foreach ($this->defaultController->em->getRepository(Service::class)->findAll() as $service) {
            $serviceLang = $this->defaultController->getLang($service->getServiceLangs(), $request);
            $urls[] = [
                'loc' => $this->generateUrl('service_detail', ['alias'=>$serviceLang->getAlias()]),
                'priority' => '0.80',
                'title' => $serviceLang->getTitle(),
                'trans' => false,
                'inline' => 1
            ];
        }
        $urls[] = [
            'loc' => $this->generateUrl('technologies', []),
            'priority' => '0.80',
            'title' => 'technologies'
        ];
        $urls[] = [
            'loc' => $this->generateUrl('projects', []),
            'priority' => '0.80',
            'title' => 'projects'
        ];
        
        // Project Pages
        foreach ($this->defaultController->em->getRepository(ProjectPage::class)->findBy(['is_enabled' => true]) as $projectPage) {
            $project = $this->defaultController->em->getRepository(Project::class)->findOneBy(['identifier'=>$projectPage->getName()]);
            $projectLang = $this->defaultController->getLang($project->getProjectLangs(), $request);
            $urls[] = [
                'loc' => $this->generateUrl('project_page', ['project_name'=>$projectPage->getName()]),
                'priority' => '0.5',
                'title' => $projectLang->getTitle(),
                'trans' => false,
                'inline' => 1
            ];
        }
        
        $urls[] = [
            'loc' => $this->generateUrl('references', []),
            'priority' => '0.80',
            'title' => 'references'
        ];
        $urls[] = [
            'loc' => $this->generateUrl('blog', []),
            'priority' => '0.80',
            'title' => 'blogs'
        ];

        // Blog Pages
        foreach ($this->defaultController->em->getRepository(Blog::class)->findBy(['is_enabled' => true]) as $blog) {
            $blogLang = $this->defaultController->getLang($blog->getBlogLangs(), $request);
            $urls[] = [
                'loc' => $this->generateUrl('blog_detail', ['alias'=>$blogLang->getAlias()]),
                'priority' => '0.50',
                'title' => $blogLang->getTitle(),
                'trans' => false,
                'inline' => 1
            ];
        }

        $urls[] = [
            'loc' => $this->generateUrl('contact', []),
            'priority' => '0.80',
            'title' => 'contact'
        ];
        foreach ($this->defaultController->em->getRepository(Page::class)->findBy(['is_at_footer'=>true]) as $page) {
            $pageLang = $this->defaultController->getLang($page->getPageLangs(), $request);
            $urls[] = [
                'loc' => $this->generateUrl('page', ['alias'=>$pageLang->getAlias()]),
                'priority' => '0.50',
                'title' => $pageLang->getTitle(),
                'trans' => false
            ];
        }
        
        return $urls;
    }

    #[Route([
        'tr' => '/sitemap.xml',
        'en' => '/{_locale}/sitemap.xml',
        'de' => '/{_locale}/sitemap.xml'
    ], name: 'sitemap_xml', format: 'xml', priority: 10)]
    public function sitemapxml(Request $request){

        $hostname = $request->getSchemeAndHttpHost();
        $xml = $this->renderView('sitemap.xml.twig', [
                'urls' => $this->getSitemap($request),
                'hostname' => $hostname
        ]);

        return new Response($xml, 200, ['Content-Type' => 'text/xml']);
    }

    #[Route([
        'tr' => '/site-haritasi',
        'en' => '/{_locale}/sitemap',
        'de' => '/{_locale}/sitemap'
    ], name: 'sitemap', priority: 10)]
    public function sitemappage(Request $request){
        $request->attributes->add(['_route' => 'sitemap']);
        $request->attributes->remove('alias');
        $request->attributes->add(['_route_params' => []]);
        
        return $this->defaultController->renderPage('sitemap.html.twig', [
            'urls' => $this->getSitemap($request)
        ]);
    }
}