<?php

namespace App\Controller;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Doctrine\ORM\EntityManagerInterface;
use App\Controller\DefaultController;
use App\Entity\Staff;

class StaffController extends AbstractController{

    private $em;
    private $defaultController;

    public function __construct(EntityManagerInterface $em, DefaultController $defaultController){
        $this->em = $em;
        $this->defaultController = $defaultController; 
    }

    public function getStaff(array $args=[]){
        $staff = $this->em->getRepository(Staff::class)->createQueryBuilder('staff')
        ->select('staff');
        if (array_key_exists('intern', $args)){
            $staff = $staff
            ->where('staff.is_intern = :is_intern')
            ->setParameter('is_intern', $args['intern']);
        }
        return $staff->getQuery()->getResult();
    }

    #[Route([
        'tr' => '/kadromuz',
        'en' => '/{_locale}/our-staff',
        'de' => '/{_locale}/unsere-mitarbeiter'
    ], name: 'staff', priority: 10)]
    public function staffpage(){
        return $this->defaultController->renderPage('staff.html.twig',
        ['breadcrumb' => ["corporate"]]);
    }

}