<?php

namespace App\Entity;

use App\Repository\AppSettingRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: AppSettingRepository::class)]
class AppSetting
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private array $social_media_array = [];

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSocialMediaArray(): array
    {
        return $this->social_media_array;
    }

    public function setSocialMediaArray(array $social_media_array): static
    {
        $this->social_media_array = $social_media_array;

        return $this;
    }
}
