<?php

namespace App\Entity;

use App\Repository\BlogRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: BlogRepository::class)]
class Blog
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    /**
     * @var Collection<int, BlogLang>
     */
    #[ORM\OneToMany(targetEntity: BlogLang::class, mappedBy: 'blog')]
    private Collection $blogLangs;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $thumbnail_image = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $image = null;
    
    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $created_at = null;

    #[ORM\Column]
    private ?bool $is_enabled = null;

    #[ORM\Column(nullable: true)]
    private ?bool $is_main = null;

    #[ORM\Column(nullable: true)]
    private ?array $tagIdentifierArray = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $vertical_image = null;

    public function __construct()
    {
        $this->blogLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return Collection<int, BlogLang>
     */
    public function getBlogLangs(): Collection
    {
        return $this->blogLangs;
    }

    public function addBlogLang(BlogLang $blogLang): static
    {
        if (!$this->blogLangs->contains($blogLang)) {
            $this->blogLangs->add($blogLang);
            $blogLang->setBlog($this);
        }

        return $this;
    }

    public function removeBlogLang(BlogLang $blogLang): static
    {
        if ($this->blogLangs->removeElement($blogLang)) {
            // set the owning side to null (unless already changed)
            if ($blogLang->getBlog() === $this) {
                $blogLang->setBlog(null);
            }
        }

        return $this;
    }

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): static
    {
        $this->image = $image;

        return $this;
    }

    public function getThumbnailImage(): ?string
    {
        return $this->thumbnail_image;
    }

    public function setThumbnailImage(?string $thumbnail_image): static
    {
        $this->thumbnail_image = $thumbnail_image;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->created_at;
    }

    public function setCreatedAt(?\DateTimeImmutable $created_at): static
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function isEnabled(): ?bool
    {
        return $this->is_enabled;
    }

    public function setIsEnabled(bool $is_enabled): static
    {
        $this->is_enabled = $is_enabled;

        return $this;
    }

    public function isMain(): ?bool
    {
        return $this->is_main;
    }

    public function setIsMain(?bool $is_main): static
    {
        $this->is_main = $is_main;

        return $this;
    }

    public function getTagIdentifierArray(): ?array
    {
        return $this->tagIdentifierArray;
    }

    public function setTagIdentifierArray(?array $tagIdentifierArray): static
    {
        $this->tagIdentifierArray = $tagIdentifierArray;

        return $this;
    }

    public function getVerticalImage(): ?string
    {
        return $this->vertical_image;
    }

    public function setVerticalImage(?string $vertical_image): static
    {
        $this->vertical_image = $vertical_image;

        return $this;
    }
}
