<?php

namespace App\Entity;

use App\Repository\LangRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: LangRepository::class)]
class Lang
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 3)]
    private ?string $code = null;

    /**
     * @var Collection<int, LangContent>
     */
    #[ORM\OneToMany(targetEntity: LangContent::class, mappedBy: 'lang')]
    private Collection $langContents;

    public function __construct()
    {
        $this->langContents = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return Collection<int, LangContent>
     */
    public function getLangContents(): Collection
    {
        return $this->langContents;
    }

    public function addLangContent(LangContent $langContent): static
    {
        if (!$this->langContents->contains($langContent)) {
            $this->langContents->add($langContent);
            $langContent->setLang($this);
        }

        return $this;
    }

    public function removeLangContent(LangContent $langContent): static
    {
        if ($this->langContents->removeElement($langContent)) {
            // set the owning side to null (unless already changed)
            if ($langContent->getLang() === $this) {
                $langContent->setLang(null);
            }
        }

        return $this;
    }
}
