<?php

namespace App\Entity;

use App\Repository\LocationRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: LocationRepository::class)]
class Location
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $phone_number = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $email = null;

    /**
     * @var Collection<int, LocationLang>
     */
    #[ORM\OneToMany(targetEntity: LocationLang::class, mappedBy: 'location')]
    private Collection $locationLangs;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $image = null;

    #[ORM\Column(length: 3, nullable: true)]
    private ?string $country_code = null;

    #[ORM\Column(length: 500, nullable: true)]
    private ?string $url = null;

    public function __construct()
    {
        $this->locationLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->phone_number;
    }

    public function setPhoneNumber(?string $phone_number): static
    {
        $this->phone_number = $phone_number;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): static
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return Collection<int, LocationLang>
     */
    public function getLocationLangs(): Collection
    {
        return $this->locationLangs;
    }

    public function addLocationLang(LocationLang $locationLang): static
    {
        if (!$this->locationLangs->contains($locationLang)) {
            $this->locationLangs->add($locationLang);
            $locationLang->setLocation($this);
        }

        return $this;
    }

    public function removeLocationLang(LocationLang $locationLang): static
    {
        if ($this->locationLangs->removeElement($locationLang)) {
            // set the owning side to null (unless already changed)
            if ($locationLang->getLocation() === $this) {
                $locationLang->setLocation(null);
            }
        }

        return $this;
    }

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): static
    {
        $this->image = $image;

        return $this;
    }

    public function getCountryCode(): ?string
    {
        return $this->country_code;
    }

    public function setCountryCode(?string $country_code): static
    {
        $this->country_code = $country_code;

        return $this;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(?string $url): static
    {
        $this->url = $url;

        return $this;
    }
}
