<?php

namespace App\Entity;

use App\Repository\PageRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PageRepository::class)]
class Page
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $name = null;

    /**
     * @var Collection<int, PageLang>
     */
    #[ORM\OneToMany(targetEntity: PageLang::class, mappedBy: 'page')]
    private Collection $pageLangs;

    #[ORM\Column(nullable: true)]
    private ?bool $is_at_footer = null;

    public function __construct()
    {
        $this->pageLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): static
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection<int, PageLang>
     */
    public function getPageLangs(): Collection
    {
        return $this->pageLangs;
    }

    public function addPageLang(PageLang $pageLang): static
    {
        if (!$this->pageLangs->contains($pageLang)) {
            $this->pageLangs->add($pageLang);
            $pageLang->setPage($this);
        }

        return $this;
    }

    public function removePageLang(PageLang $pageLang): static
    {
        if ($this->pageLangs->removeElement($pageLang)) {
            // set the owning side to null (unless already changed)
            if ($pageLang->getPage() === $this) {
                $pageLang->setPage(null);
            }
        }

        return $this;
    }

    public function isAtFooter(): ?bool
    {
        return $this->is_at_footer;
    }

    public function setIsAtFooter(?bool $is_at_footer): static
    {
        $this->is_at_footer = $is_at_footer;

        return $this;
    }
}
