<?php

namespace App\Entity;

use App\Repository\PartnerRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PartnerRepository::class)]
class Partner
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'partners')]
    #[ORM\JoinColumn(nullable: false)]
    private ?PartnerCategory $category = null;

    #[ORM\Column(nullable: true)]
    private ?int $share_percent = null;

    /**
     * @var Collection<int, PartnerLang>
     */
    #[ORM\OneToMany(targetEntity: PartnerLang::class, mappedBy: 'partner')]
    private Collection $partnerLangs;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $logo = null;

    public function __construct()
    {
        $this->partnerLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCategory(): ?PartnerCategory
    {
        return $this->category;
    }

    public function setCategory(?PartnerCategory $category): static
    {
        $this->category = $category;

        return $this;
    }

    public function getSharePercent(): ?int
    {
        return $this->share_percent;
    }

    public function setSharePercent(?int $share_percent): static
    {
        $this->share_percent = $share_percent;

        return $this;
    }

    /**
     * @return Collection<int, PartnerLang>
     */
    public function getPartnerLangs(): Collection
    {
        return $this->partnerLangs;
    }

    public function addPartnerLang(PartnerLang $partnerLang): static
    {
        if (!$this->partnerLangs->contains($partnerLang)) {
            $this->partnerLangs->add($partnerLang);
            $partnerLang->setPartner($this);
        }

        return $this;
    }

    public function removePartnerLang(PartnerLang $partnerLang): static
    {
        if ($this->partnerLangs->removeElement($partnerLang)) {
            // set the owning side to null (unless already changed)
            if ($partnerLang->getPartner() === $this) {
                $partnerLang->setPartner(null);
            }
        }

        return $this;
    }

    public function getLogo(): ?string
    {
        return $this->logo;
    }

    public function setLogo(?string $logo): static
    {
        $this->logo = $logo;

        return $this;
    }
}
