<?php

namespace App\Entity;

use App\Repository\ProjectRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ProjectRepository::class)]
class Project
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $identifier = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $icon_image = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $logoImage = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $bannerImage = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $link = null;

    #[ORM\Column]
    private ?bool $is_at_home_brands = null;

    #[ORM\Column]
    private ?bool $is_at_projects_page = null;

    #[ORM\Column(nullable: true)]
    private ?array $tag_identifier_array = null;

    #[ORM\Column]
    private ?bool $is_at_home_projects = null;

    /**
     * @var Collection<int, ProjectLang>
     */
    #[ORM\OneToMany(targetEntity: ProjectLang::class, mappedBy: 'project')]
    private Collection $projectLangs;

    #[ORM\Column(length: 9, nullable: true)]
    private ?string $color = null;

    public function __construct()
    {
        $this->projectLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIdentifier(): ?string
    {
        return $this->identifier;
    }

    public function setIdentifier(string $identifier): static
    {
        $this->identifier = $identifier;

        return $this;
    }

    public function getIconImage(): ?string
    {
        return $this->icon_image;
    }

    public function setIconImage(?string $icon_image): static
    {
        $this->icon_image = $icon_image;

        return $this;
    }

    public function getLogoImage(): ?string
    {
        return $this->logoImage;
    }

    public function setLogoImage(?string $logoImage): static
    {
        $this->logoImage = $logoImage;

        return $this;
    }

    public function getBannerImage(): ?string
    {
        return $this->bannerImage;
    }

    public function setBannerImage(?string $bannerImage): static
    {
        $this->bannerImage = $bannerImage;

        return $this;
    }

    public function getLink(): ?string
    {
        return $this->link;
    }

    public function setLink(?string $link): static
    {
        $this->link = $link;

        return $this;
    }

    public function isAtHomeBrands(): ?bool
    {
        return $this->is_at_home_brands;
    }

    public function setIsAtHomeBrands(bool $is_at_home_brands): static
    {
        $this->is_at_home_brands = $is_at_home_brands;

        return $this;
    }

    public function isAtProjectsPage(): ?bool
    {
        return $this->is_at_projects_page;
    }

    public function setIsAtProjectsPage(bool $is_at_projects_page): static
    {
        $this->is_at_projects_page = $is_at_projects_page;

        return $this;
    }

    public function getTagIdentifierArray(): ?array
    {
        return $this->tag_identifier_array;
    }

    public function setTagIdentifierArray(?array $tag_identifier_array): static
    {
        $this->tag_identifier_array = $tag_identifier_array;

        return $this;
    }

    public function isAtHomeProjects(): ?bool
    {
        return $this->is_at_home_projects;
    }

    public function setIsAtHomeProjects(bool $is_at_home_projects): static
    {
        $this->is_at_home_projects = $is_at_home_projects;

        return $this;
    }

    /**
     * @return Collection<int, ProjectLang>
     */
    public function getProjectLangs(): Collection
    {
        return $this->projectLangs;
    }

    public function addProjectLang(ProjectLang $projectLang): static
    {
        if (!$this->projectLangs->contains($projectLang)) {
            $this->projectLangs->add($projectLang);
            $projectLang->setProject($this);
        }

        return $this;
    }

    public function removeProjectLang(ProjectLang $projectLang): static
    {
        if ($this->projectLangs->removeElement($projectLang)) {
            // set the owning side to null (unless already changed)
            if ($projectLang->getProject() === $this) {
                $projectLang->setProject(null);
            }
        }

        return $this;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function setColor(?string $color): static
    {
        $this->color = $color;

        return $this;
    }
}
