<?php

namespace App\Entity;

use App\Repository\ProjectLangRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ProjectLangRepository::class)]
class ProjectLang
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    private ?Lang $lang = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $title = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $home_brands_description = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $home_projects_description = null;

    #[ORM\ManyToOne(inversedBy: 'projectLangs')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Project $project = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getLang(): ?Lang
    {
        return $this->lang;
    }

    public function setLang(?Lang $lang): static
    {
        $this->lang = $lang;

        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): static
    {
        $this->title = $title;

        return $this;
    }

    public function getHomeBrandsDescription(): ?string
    {
        return $this->home_brands_description;
    }

    public function setHomeBrandsDescription(?string $home_brands_description): static
    {
        $this->home_brands_description = $home_brands_description;

        return $this;
    }

    public function getHomeProjectsDescription(): ?string
    {
        return $this->home_projects_description;
    }

    public function setHomeProjectsDescription(?string $home_projects_description): static
    {
        $this->home_projects_description = $home_projects_description;

        return $this;
    }

    public function getProject(): ?Project
    {
        return $this->project;
    }

    public function setProject(?Project $project): static
    {
        $this->project = $project;

        return $this;
    }
}
