<?php

namespace App\Entity;

use App\Repository\ProjectPageRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ProjectPageRepository::class)]
class ProjectPage
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\OneToOne(cascade: ['persist', 'remove'])]
    #[ORM\JoinColumn(nullable: false)]
    private ?ProjectPageContent $content = null;

    #[ORM\Column]
    private ?bool $is_enabled = null;

    /**
     * @var Collection<int, ProjectPageLang>
     */
    #[ORM\OneToMany(targetEntity: ProjectPageLang::class, mappedBy: 'project_page')]
    private Collection $projectPageLangs;

    public function __construct()
    {
        $this->projectPageLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getContent(): ?ProjectPageContent
    {
        return $this->content;
    }

    public function setContent(ProjectPageContent $content): static
    {
        $this->content = $content;

        return $this;
    }

    public function isEnabled(): ?bool
    {
        return $this->is_enabled;
    }

    public function setIsEnabled(bool $is_enabled): static
    {
        $this->is_enabled = $is_enabled;

        return $this;
    }

    /**
     * @return Collection<int, ProjectPageLang>
     */
    public function getProjectPageLangs(): Collection
    {
        return $this->projectPageLangs;
    }

    public function addProjectPageLang(ProjectPageLang $projectPageLang): static
    {
        if (!$this->projectPageLangs->contains($projectPageLang)) {
            $this->projectPageLangs->add($projectPageLang);
            $projectPageLang->setProjectPage($this);
        }

        return $this;
    }

    public function removeProjectPageLang(ProjectPageLang $projectPageLang): static
    {
        if ($this->projectPageLangs->removeElement($projectPageLang)) {
            // set the owning side to null (unless already changed)
            if ($projectPageLang->getProjectPage() === $this) {
                $projectPageLang->setProjectPage(null);
            }
        }

        return $this;
    }
}
