<?php

namespace App\Entity;

use App\Repository\ProjectPageContentRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ProjectPageContentRepository::class)]
class ProjectPageContent
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 9)]
    private ?string $color_code = null;

    #[ORM\Column(length: 255)]
    private ?string $url = null;

    #[ORM\Column(nullable: true)]
    private ?array $featured_slider = null;

    #[ORM\Column(length: 9)]
    private ?string $background_color_code = null;

    #[ORM\Column]
    private array $content = [];

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getColorCode(): ?string
    {
        return $this->color_code;
    }

    public function setColorCode(string $color_code): static
    {
        $this->color_code = $color_code;

        return $this;
    }
    
    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(string $url): static
    {
        $this->url = $url;

        return $this;
    }

    public function getFeaturedSlider(): ?array
    {
        return $this->featured_slider;
    }

    public function setFeaturedSlider(?array $featured_slider): static
    {
        $this->featured_slider = $featured_slider;

        return $this;
    }

    public function getBackgroundColorCode(): ?string
    {
        return $this->background_color_code;
    }

    public function setBackgroundColorCode(string $background_color_code): static
    {
        $this->background_color_code = $background_color_code;

        return $this;
    }

    public function getContent(): array
    {
        return $this->content;
    }

    public function setContent(array $content): static
    {
        $this->content = $content;

        return $this;
    }
}
