<?php

namespace App\Entity;

use App\Repository\ReferenceRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ReferenceRepository::class)]
class Reference
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $identifier = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $logo_image = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $link = null;

    #[ORM\Column(length: 3, nullable: true)]
    private ?string $country_code = null;

    #[ORM\Column(nullable: true)]
    private ?bool $is_enabled = null;

    /**
     * @var Collection<int, ReferenceLang>
     */
    #[ORM\OneToMany(targetEntity: ReferenceLang::class, mappedBy: 'reference')]
    private Collection $referenceLangs;

    #[ORM\Column]
    private ?bool $has_popup = null;

    #[ORM\Column(nullable: true)]
    private ?bool $is_image_full = null;

    #[ORM\Column(nullable: true)]
    private ?int $sort_order = null;

    public function __construct()
    {
        $this->referenceLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIdentifier(): ?string
    {
        return $this->identifier;
    }

    public function setIdentifier(string $identifier): static
    {
        $this->identifier = $identifier;

        return $this;
    }

    public function getLogoImage(): ?string
    {
        return $this->logo_image;
    }

    public function setLogoImage(?string $logo_image): static
    {
        $this->logo_image = $logo_image;

        return $this;
    }

    public function getLink(): ?string
    {
        return $this->link;
    }

    public function setLink(?string $link): static
    {
        $this->link = $link;

        return $this;
    }

    public function getCountryCode(): ?string
    {
        return $this->country_code;
    }

    public function setCountryCode(?string $country_code): static
    {
        $this->country_code = $country_code;

        return $this;
    }

    public function isEnabled(): ?bool
    {
        return $this->is_enabled;
    }

    public function setIsEnabled(?bool $is_enabled): static
    {
        $this->is_enabled = $is_enabled;

        return $this;
    }

    /**
     * @return Collection<int, ReferenceLang>
     */
    public function getReferenceLangs(): Collection
    {
        return $this->referenceLangs;
    }

    public function addReferenceLang(ReferenceLang $referenceLang): static
    {
        if (!$this->referenceLangs->contains($referenceLang)) {
            $this->referenceLangs->add($referenceLang);
            $referenceLang->setReference($this);
        }

        return $this;
    }

    public function removeReferenceLang(ReferenceLang $referenceLang): static
    {
        if ($this->referenceLangs->removeElement($referenceLang)) {
            // set the owning side to null (unless already changed)
            if ($referenceLang->getReference() === $this) {
                $referenceLang->setReference(null);
            }
        }

        return $this;
    }

    public function hasPopup(): ?bool
    {
        return $this->has_popup;
    }

    public function setHasPopup(bool $has_popup): static
    {
        $this->has_popup = $has_popup;

        return $this;
    }

    public function isImageFull(): ?bool
    {
        return $this->is_image_full;
    }

    public function setIsImageFull(?bool $is_image_full): static
    {
        $this->is_image_full = $is_image_full;

        return $this;
    }

    public function getSortOrder(): ?int
    {
        return $this->sort_order;
    }

    public function setSortOrder(?int $sort_order): static
    {
        $this->sort_order = $sort_order;

        return $this;
    }
}
