<?php

namespace App\Entity;

use App\Repository\ServiceRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ServiceRepository::class)]
class Service
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\OneToOne(cascade: ['persist', 'remove'])]
    #[ORM\JoinColumn(nullable: false)]
    private ?ServiceContent $content = null;

    /**
     * @var Collection<int, ServiceLang>
     */
    #[ORM\OneToMany(targetEntity: ServiceLang::class, mappedBy: 'service')]
    private Collection $serviceLangs;

    #[ORM\Column(length: 255)]
    private ?string $alias = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $intro_image = null;

    #[ORM\Column]
    private array $referenceIdentiferArray = [];

    public function __construct()
    {
        $this->serviceLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getContent(): ?ServiceContent
    {
        return $this->content;
    }

    public function setContent(ServiceContent $content): static
    {
        $this->content = $content;

        return $this;
    }

    /**
     * @return Collection<int, ServiceLang>
     */
    public function getServiceLangs(): Collection
    {
        return $this->serviceLangs;
    }

    public function addServiceLang(ServiceLang $serviceLang): static
    {
        if (!$this->serviceLangs->contains($serviceLang)) {
            $this->serviceLangs->add($serviceLang);
            $serviceLang->setService($this);
        }

        return $this;
    }

    public function removeServiceLang(ServiceLang $serviceLang): static
    {
        if ($this->serviceLangs->removeElement($serviceLang)) {
            // set the owning side to null (unless already changed)
            if ($serviceLang->getService() === $this) {
                $serviceLang->setService(null);
            }
        }

        return $this;
    }

    public function getAlias(): ?string
    {
        return $this->alias;
    }

    public function setAlias(string $alias): static
    {
        $this->alias = $alias;

        return $this;
    }

    public function getIntroImage(): ?string
    {
        return $this->intro_image;
    }

    public function setIntroImage(?string $intro_image): static
    {
        $this->intro_image = $intro_image;

        return $this;
    }

    public function getReferenceIdentiferArray(): array
    {
        return $this->referenceIdentiferArray;
    }

    public function setReferenceIdentiferArray(array $referenceIdentiferArray): static
    {
        $this->referenceIdentiferArray = $referenceIdentiferArray;

        return $this;
    }
}
