<?php

namespace App\Entity;

use App\Repository\ServiceContentRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ServiceContentRepository::class)]
class ServiceContent
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private array $content = [];

    #[ORM\Column]
    private array $ddbox_item_array = [];

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getContent(): array
    {
        return $this->content;
    }

    public function setContent(array $content): static
    {
        $this->content = $content;

        return $this;
    }

    public function getDdboxItemArray(): array
    {
        return $this->ddbox_item_array;
    }

    public function setDdboxItemArray(array $ddbox_item_array): static
    {
        $this->ddbox_item_array = $ddbox_item_array;

        return $this;
    }
}
