<?php

namespace App\Entity;

use App\Repository\ServiceLangRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ServiceLangRepository::class)]
class ServiceLang
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    private ?Lang $lang = null;

    #[ORM\ManyToOne(inversedBy: 'serviceLangs')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Service $service = null;

    #[ORM\Column(length: 255)]
    private ?string $alias = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $intro_title = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $intro_description = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $text_title = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $text_description = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $reference_section_title = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $title = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $keywords = null;

    #[ORM\Column(length: 320, nullable: true)]
    private ?string $meta_description = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getLang(): ?Lang
    {
        return $this->lang;
    }

    public function setLang(?Lang $lang): static
    {
        $this->lang = $lang;

        return $this;
    }

    public function getService(): ?Service
    {
        return $this->service;
    }

    public function setService(?Service $service): static
    {
        $this->service = $service;

        return $this;
    }

    public function getAlias(): ?string
    {
        return $this->alias;
    }

    public function setAlias(string $alias): static
    {
        $this->alias = $alias;

        return $this;
    }

    public function getIntroTitle(): ?string
    {
        return $this->intro_title;
    }

    public function setIntroTitle(?string $intro_title): static
    {
        $this->intro_title = $intro_title;

        return $this;
    }

    public function getIntroDescription(): ?string
    {
        return $this->intro_description;
    }

    public function setIntroDescription(?string $intro_description): static
    {
        $this->intro_description = $intro_description;

        return $this;
    }

    public function getTextTitle(): ?string
    {
        return $this->text_title;
    }

    public function setTextTitle(?string $text_title): static
    {
        $this->text_title = $text_title;

        return $this;
    }

    public function getTextDescription(): ?string
    {
        return $this->text_description;
    }

    public function setTextDescription(?string $text_description): static
    {
        $this->text_description = $text_description;

        return $this;
    }

    public function getReferenceSectionTitle(): ?string
    {
        return $this->reference_section_title;
    }

    public function setReferenceSectionTitle(?string $reference_section_title): static
    {
        $this->reference_section_title = $reference_section_title;

        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): static
    {
        $this->title = $title;

        return $this;
    }

    public function getKeywords(): ?string
    {
        return $this->keywords;
    }

    public function setKeywords(?string $keywords): static
    {
        $this->keywords = $keywords;

        return $this;
    }

    public function getMetaDescription(): ?string
    {
        return $this->meta_description;
    }

    public function setMetaDescription(?string $meta_description): static
    {
        $this->meta_description = $meta_description;

        return $this;
    }
}
