<?php

namespace App\Entity;

use App\Repository\StaffRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: StaffRepository::class)]
class Staff
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $image = null;

    #[ORM\ManyToOne(inversedBy: 'staff')]
    private ?StaffRole $role = null;

    /**
     * @var Collection<int, StaffLang>
     */
    #[ORM\OneToMany(targetEntity: StaffLang::class, mappedBy: 'staff')]
    private Collection $staffLangs;

    #[ORM\Column(nullable: true)]
    private ?bool $is_intern = null;

    public function __construct()
    {
        $this->staffLangs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): static
    {
        $this->image = $image;

        return $this;
    }

    public function getRole(): ?StaffRole
    {
        return $this->role;
    }

    public function setRole(?StaffRole $role): static
    {
        $this->role = $role;

        return $this;
    }

    /**
     * @return Collection<int, StaffLang>
     */
    public function getStaffLangs(): Collection
    {
        return $this->staffLangs;
    }

    public function addStaffLang(StaffLang $staffLang): static
    {
        if (!$this->staffLangs->contains($staffLang)) {
            $this->staffLangs->add($staffLang);
            $staffLang->setStaff($this);
        }

        return $this;
    }

    public function removeStaffLang(StaffLang $staffLang): static
    {
        if ($this->staffLangs->removeElement($staffLang)) {
            // set the owning side to null (unless already changed)
            if ($staffLang->getStaff() === $this) {
                $staffLang->setStaff(null);
            }
        }

        return $this;
    }

    public function isIntern(): ?bool
    {
        return $this->is_intern;
    }

    public function setIsIntern(?bool $is_intern): static
    {
        $this->is_intern = $is_intern;

        return $this;
    }
}
